package com.ejie.aa94a.model.calculo;

import java.io.Serializable;
import java.util.List;

import com.ejie.aa94a.model.config.Posicion;
import com.ejie.aa94a.model.config.Solucion;
import com.ejie.aa94a.model.config.TipoDistancia;

public class Resultado implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Solucion solucion;
	private boolean haySolucion = false;
	private List<Mensaje> mensajes;
	private List<Bobina> ubicaciones;
	private Transporte transporte;

	private boolean mostrarGraficos = true;

	/**
	 * @return the solucion
	 */
	public Solucion getSolucion() {
		return solucion;
	}

	/**
	 * @param solucion
	 *            the solucion to set
	 */
	public void setSolucion(Solucion solucion) {
		this.solucion = solucion;
	}

	/**
	 * @return the mensajes
	 */

	public List<Mensaje> getMensajes() {
		return mensajes;
	}

	/**
	 * @param mensajes
	 *            the mensajes to set
	 */

	public void setMensajes(List<Mensaje> mensajes) {
		this.mensajes = mensajes;
	}

	/**
	 * @return the ubicaciones
	 */

	public List<Bobina> getUbicaciones() {
		return ubicaciones;
	}

	/**
	 * @return the transporte
	 */
	public Transporte getTransporte() {
		return transporte;
	}

	/**
	 * @param transporte
	 *            the transporte to set
	 */
	public void setTransporte(Transporte transporte) {
		this.transporte = transporte;
	}

	/**
	 * @param ubicaciones
	 *            the ubicaciones to set
	 */
	public void setUbicaciones(List<Bobina> ubicaciones) {
		if (ubicaciones != null && !ubicaciones.isEmpty()) {
			List<Posicion> posiciones = this.solucion.getPosiciones();
			for (int i = 0; i < ubicaciones.size(); i++) {
				ubicaciones.get(i).setPosicion(posiciones.get(i));
			}
		}
		this.ubicaciones = ubicaciones;
		this.haySolucion = true;
	}

	/**
	 * 
	 * 
	 * @return estibas
	 */
	public List<Estiba> getEstibas() {
		List<Estiba> obj = null;
		if (this.solucion != null) {
			obj = this.solucion.getEstibas();
		}
		return obj;
	}

	/**
	 * 
	 * @return grafico
	 */
	public String getGrafico() {
		String obj = null;
		if (this.solucion != null) {
			obj = this.solucion.getGrafico();
		}
		return obj;
	}

	/**
	 * 
	 * 
	 * @return tipoDistancia
	 */
	public TipoDistancia getTipoDistancia() {
		TipoDistancia tipoDistancia = null;
		if (this.solucion != null) {
			tipoDistancia = this.solucion.getTipoDistancia();
		}
		return tipoDistancia;
	}

	/**
	 * Obtiene la traza de la solucion
	 * 
	 * @return String
	 */
	public String getTrazaSolucion() {
		StringBuffer stb = new StringBuffer();
		if (this.solucion != null) {
			stb.append("\nBobina: ");
			if (this.getUbicaciones() != null) {
				for (Bobina bobina : this.getUbicaciones()) {
					stb.append(bobina.getIdentificador()).append(" ")
							.append(bobina.getDistancia()).append(" ");
				}
			}
			stb.append("\nEstiba: ");
			if (this.getEstibas() != null) {
				for (Estiba estiba : this.getEstibas()) {
					stb.append(estiba.getCodigo()).append(" ");
				}
			}
			stb.append("\nGrafico: ").append(this.getGrafico());
			stb.append("\nDistancia: ").append(
					this.getTipoDistancia().getCodigo());

		}
		return stb.toString();
	}

	/**
	 * @return the haySolucion
	 */
	public boolean isHaySolucion() {
		return haySolucion;
	}

	/**
	 * @param haySolucion
	 *            the haySolucion to set
	 */
	public void setHaySolucion(boolean haySolucion) {
		this.haySolucion = haySolucion;
	}

	/**
	 * @return the mostrarGraficos
	 */
	public boolean isMostrarGraficos() {
		return mostrarGraficos;
	}

	/**
	 * @param mostrarGraficos
	 *            the mostrarGraficos to set
	 */
	public void setMostrarGraficos(boolean mostrarGraficos) {
		this.mostrarGraficos = mostrarGraficos;
	}

}
